﻿//$(document).ready(function ()
//{
// Load the Visualization API and the piechart package.
//google.load('visualization', '1.0', { 'packages': ['corechart'] });

google.load('visualization', '1', { 'packages': ['corechart'] });
// Set a callback to run when the Google Visualization API is loaded.

google.setOnLoadCallback(drawChart);

// Callback that creates and populates a data table,
// instantiates the pie chart, passes in the data and
// draws it.

var dataChart = {};

function drawChart()
{
    for (var lng in dataChart)
    {
        var data = new google.visualization.arrayToDataTable(dataChart[lng].data);
        var options = {};
        if (typeof (dataChart[lng].options) != 'undefined')
        {
            options = dataChart[lng].options;
        }


        var destination = document.getElementById(dataChart[lng].id);
        var GraphType = dataChart[lng].type.toUpperCase();

        if (GraphType == '')
        {
            GraphType = 'BAR';
        }
        var Largeur = 700;
        var Hauteur = 300;

        if (typeof (destination) != 'undefined')
        {
            //options.chartArea = { height: 250, width: 250 };
            options.width = Largeur;
            //options.chartArea = { height: 250};
            options.height = Hauteur;
            options.displayMode = 'markers';
            options.colorAxis = { colors: ['green', 'blue'] };
            options.magnifyingGlass = { enable: true, zoomFactor: 5.0 };
            options.animation = { duration: 1000, easing: 'out' };

            if (GraphType == 'GEO')
            {
                //destination.style.display = 'none';
                options.resolution = dataChart[lng].resolution;
                options.region = dataChart[lng].region;
                options.markerOpacity = 1.0;
                options.keepAspectRatio = true;
                options.enableRegionInteractivity = true;
                //animation: { duration: 1000, easing: 'out' }
                var chart = new google.visualization.GeoChart(destination);

            }
            if (GraphType == 'BAR')
            {
                //alert(data.getNumberOfRows());
                //var Hauteur = (data.getNumberOfRows() - (data.getNumberOfRows() % 10)) * 7;
                options.fontSize = 10;
                var chart = new google.visualization.BarChart(destination);
            }
            if (GraphType == 'COL')
            {
                options.fontSize = 12;
                options.legend = { position: 'right', textStyle: { color: 'blue', fontname: 'tahoma', fontSize: 12 } };
                var chart = new google.visualization.ColumnChart(destination);
            }
            if (GraphType == 'HISTO')
            {
                options.fontSize = 12;
                options.legend = { position: 'top', textStyle: { color: 'blue', fontname: 'tahoma', fontSize: 12 } };
                var chart = new google.visualization.Histogram(destination);
            }
            if (GraphType == 'LINE')
            {
                options.fontSize = 12;
                options.legend = { position: 'right', textStyle: { color: 'blue', fontname: 'tahoma', fontSize: 12 } };

                var chart = new google.visualization.LineChart(destination);
            }

            if (GraphType == 'PIE')
            {
                var chart = new google.visualization.PieChart(destination);
            }
            if (typeof(dataChart[lng].showError) == 'undefined' || !dataChart[lng].showError )
            {
                google.visualization.events.addListener(chart, 'error', function (err)
                {
                    var errorElem = document.getElementById(err.id);
                    if (typeof (errorElem) != 'undefined')
                    {
                        var pErrorElem = errorElem.parentElement;
                        if (typeof (pErrorElem) != 'undefined')
                        {
                            var TDErrorElem = errorElem.parentElement;
                            if (typeof (TDErrorElem) != 'undefined')
                            {
                                TDErrorElem.style.display = 'none';
                            }
                        }
                    }
                });
            }

            chart.draw(data, options);
        }
    }
}

function ComputeGraph()
{
    var tbl = document.getElementById(tblID);
    if (typeof (tbl) != 'undefined')
    {

    }

}