﻿var setCookie = function (cname, cvalue, exdays)
{
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

var setCookies = function ()
{
    $('[cookiename]').each(function ()
    {
        if ($(this).attr('cookiename') != '')
        {
            setCookie($(this).attr('cookiename'), $(this).val(), 365);
        }
    });
}

function getCookie(cname)
{
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for (var i = 0; i < ca.length; i++)
    {
        var c = ca[i];
        while (c.charAt(0) == ' ')
        {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0)
        {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function getCookies()
{
    $('[cookiename]').each(function ()
    {
        if ($(this).attr('cookiename') != '')
        {
            var tmp = getCookie($(this).attr('cookiename'));
            if (tmp != '')
            {
                $(this).val(tmp)
            }
        }
    });
}




if (Object.defineProperty
  && Object.getOwnPropertyDescriptor
  && Object.getOwnPropertyDescriptor(Element.prototype, "textContent")
  && !Object.getOwnPropertyDescriptor(Element.prototype, "textContent").get)
{
    (function ()
    {
        var innerText = Object.getOwnPropertyDescriptor(Element.prototype, "innerText");
        Object.defineProperty(Element.prototype, "textContent",
         {
             get: function ()
             {
                 return innerText.get.call(this);
             },
             set: function (s)
             {
                 return innerText.set.call(this, s);
             }
         }
       );
    })();
}
function snpSetAttribute(el, attrName, attrValue)
{
    if (el)
    {
        if (!is.snpFunction(el.setAttribute))
        {
            for (var i = 0; i < el.attributes.item.length; i++)
            {
                alert(el.attributes.item(i));
            }
        }
        else
        {
            alert("yes");
            el.setAttribute(attrName, attrValue);
        }
    }
}

var snpNavigateur = {
    _OS: '',
    _version: -1,
    _browser: '',
    OS: function ()
    {
        if (this._OS == '')
        {
            this.initBrowser();
        }
        return this._OS.toUpperCase();
    },
    version: function ()
    {
        if (this._version == -1)
        {
            this.initBrowser();
        }
        return this._version;
    },
    browser: function ()
    {
        if (this._browser == '')
        {
            this.initBrowser();
        }
        return this._browser.toUpperCase();
    },
    initBrowser: function ()
    {
        if (this._browser == '' && this._OS == '')
        {
            this._version = function ()
            {
                var rv = -1;
                if (navigator.appName == 'Microsoft Internet Explorer')
                {
                    var ua = navigator.userAgent;
                    var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                    if (re.exec(ua) != null)
                        rv = parseFloat(RegExp.$1);
                }
                else if (navigator.appName == 'Netscape')
                {
                    var ua = navigator.userAgent;
                    var re = new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})");
                    if (re.exec(ua) != null)
                        rv = parseFloat(RegExp.$1);
                }
                return rv;
            }();
            if (this._version != -1)
            {
                this._browser = "IE";
            }
            else
            {
                var detect = navigator.userAgent.toLowerCase();
                var str = { valeur: '' };
                var pos = { valeur: -1 };

                if (this.checkIt(detect, 'konqueror', str, pos))
                {
                    this._browser = "Konqueror";
                    this.OS = "Linux";
                }
                else if (this.checkIt(detect, 'chrome', str, pos)) this._browser = "Chrome";
                else if (this.checkIt(detect, 'safari', str, pos)) this._browser = "Safari";
                else if (this.checkIt(detect, 'omniweb', str, pos)) this._browser = "OmniWeb";
                else if (this.checkIt(detect, 'opera', str, pos)) this._browser = "Opera";
                else if (this.checkIt(detect, 'webtv', str, pos)) this._browser = "WebTV";
                else if (this.checkIt(detect, 'icab', str, pos)) this._browser = "iCab";
                else if (this.checkIt(detect, 'msie', str, pos)) this._browser = "IE";
                else if (!this.checkIt(detect, 'compatible', str, pos))
                {
                    this._browser = "Netscape";
                    this._version = detect.charAt(8);
                }
                else this._browser = "An unknown browser";
                if (this._version == -1)
                {
                    var endVersion = detect.indexOf(' ', pos.valeur + 1);
                    this._version = detect.substring(pos.valeur + str.valeur.length + 1, endVersion);
                }

                if (this._OS == '')
                {
                    if (this.checkIt(detect, 'linux', str, pos)) this._OS = "Linux";
                    else if (this.checkIt(detect, 'x11', str, pos)) this._OS = "Unix";
                    else if (this.checkIt(detect, 'mac', str, pos)) this._OS = "Mac"
                    else if (this.checkIt(detect, 'win', str, pos)) this._OS = "Windows"
                    else this._OS = "an unknown operating system";
                }
            }
        }
    },
    checkIt: function (detect, toFind, matchStr, position)
    {
        position.valeur = detect.indexOf(toFind);
        if (position.valeur != -1)
        {
            matchStr.valeur = toFind;
            return true;
        }
        else
        {
            return false;
        }
    }

}

var is = {
    snpDefined: function (data)
    {
        if (typeof (data) == 'undefined')
        {
            return false;
        }
        else
        {
            return true;
        }
    },
    snpUndefined: function (data)
    {
        if (typeof (data) == 'undefined')
        {
            return true;
        }
        else
        {
            return false;
        }
    },
    snpFunction: function (data)
    {
        if (typeof (data) == 'function')
        {
            return true;
        }
        else
        {
            return false;
        }
    },
    snpNull: function (data)
    {
        if (data == null)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

}

var target = {
    self: function () { return '_self'; },
    blank: function () { return '_blank'; },
    parent: function () { return '_parent'; },
    top: function () { return '_top'; },
    named: function (name) { return name; }
}

function commonPrint()
{
    if (is.snpFunction(CloseFilterDlg))
    {
        CloseFilterDlg();
    }

    var oldWidth;
    var fixedTableContainerInner = document.getElementById('fixed-table-container-inner');
    if (is.snpDefined(fixedTableContainerInner))
    {
        var theTbl = fixedTableContainerInner.children[0];
        if (theTbl.tagName.toUpperCase() == 'TABLE')
        {
            oldWidth = fixedTableContainerInner.offsetWidth;
            fixedTableContainerInner.style.width = theTbl.offsetWidth + "px";
        }
    }
    window.print();
    fixedTableContainerInner.style.width = oldWidth + "px";
}

function commonRefresh()
{
    window.open(myUrlInfo.cheminComplet(), target.self(), '', true);
}

function commonTicket(evt)
{

    //Title
    //CptReport
    //SubTotals
    //GroupOn

    var cnc = document.getElementById('hiddenCnc');
    var sql = document.getElementById('hiddenSQL');
    var Title = document.getElementById('hiddenTitle');
    var CptReport = document.getElementById('hiddenCptReport');
    var SubTotals = document.getElementById('hiddenSubTotals');
    var GroupOn = document.getElementById('hiddenGroupOn');

    if (is.snpDefined(cnc) && is.snpDefined(sql) && is.snpDefined(Title) && is.snpDefined(CptReport) && is.snpDefined(SubTotals) && is.snpDefined(GroupOn))
    {
        qs = "CNC=" + window.atob(cnc.value) + "&SQL=" + window.atob(sql.value) + "&Title=" + window.atob(Title.value) + "&CptReport=" + window.atob(CptReport.value) + "&SubTotals=" + window.atob(SubTotals.value) + "&GroupOn=" + window.atob(GroupOn.value);
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + '?' + btoa(qs), 'Ticket');
    }
}

function commonExcel(event)
{
    var theID = myUrlInfo.queryString("ID");
    if (theID != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=XLS&" + "ID=" + theID);
        return;
    }
    var theTicket = myUrlInfo.queryString("Ticket");
    if (theTicket != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=XLS&" + "Ticket=" + theTicket);
        return;
    }
}

function commonPivot(event)
{
    var theID = myUrlInfo.queryString("ID");
    if (theID != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=PIVOT&" + "ID=" + theID);
        return;
    }
    var theTicket = myUrlInfo.queryString("Ticket");
    if (theTicket != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=PIVOT&" + "Ticket=" + theTicket);
        return;
    }
}

function commonPivotLink(event)
{
    var theID = myUrlInfo.queryString("ID");
    if (theID != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=PIVOTLINKED&" + "ID=" + theID, target.self);
        return;
    }
    var theTicket = myUrlInfo.queryString("Ticket");
    if (theTicket != "")
    {
        window.open(myUrlInfo.cheminRepertoire() + "/" + myUrlInfo.nomDuFichier() + "?" + "output=PIVOTLINKED&" + "Ticket=" + theTicket);
        return;
    }
}

// récupération information sur url de la page

var myUrlInfo =
{
    cheminComplet: function () { return document.location.href; },
    cheminRepertoire: function ()
    {
        return this.cheminComplet().substring(0, this.cheminComplet().lastIndexOf("/"));
    },
    nomDuFichier: function ()
    {
        var posInterro = this.cheminComplet().lastIndexOf("?");
        if (posInterro == -1)
        {
            return this.cheminComplet().substring(this.cheminComplet().lastIndexOf("/") + 1);
        }
        else
        {
            return this.cheminComplet().substring(this.cheminComplet().lastIndexOf("/") + 1, posInterro);
        }
    },
    queryString: function (key)
    {
        var posInterro = this.cheminComplet().lastIndexOf("?");
        if (posInterro == -1)
        {
            return "";
        }
        else
        {
            if (is.snpUndefined(key) || key == "")
            {
                return this.cheminComplet().substring(posInterro + 1);
            }
            else
            {
                key = key.toUpperCase();
                var Lst = this.requestStringTable();
                var retour;
                for (var i = 0; i < Lst.length; i++)
                {
                    if (Lst[i].key == key)
                    {
                        return Lst[i].value;
                    }
                }
                return "";
            }
        }
    },
    requestStringTable: function ()
    {
        var rqst = this.queryString();
        if (rqst == "")
        {
            return null;
        }
        else
        {
            var retour = [];
            var RqStr;
            var rqSplitted = rqst.split('&');
            for (var i in rqSplitted)
            {
                var subRq = rqSplitted[i];
                var subRqSplitted = subRq.split("=");
                if (subRqSplitted.length == 2)
                {
                    RqStr = {
                        key: subRqSplitted[0].toUpperCase(),
                        value: subRqSplitted[1]
                    };
                }
                else
                {
                    RqStr = {
                        key: i,
                        value: subRqSplitted[0]
                    };
                }
                retour[i] = RqStr;
            }
            return retour;
        }
    }
}



var GestionDate =
    {
        parse: function (dateStr)
        {
            var firstSepar = dateStr.indexOf("/");
            if (firstSepar == -1)
            {
                //return new Date(1900, 0, 1);
                return null;
            }
            else
            {
                var secondSepar = dateStr.indexOf("/", firstSepar + 1);
                if (secondSepar == -1)
                {
                    //return new Date(1900, 0, 1);
                    return null;
                }
                else
                {
                    var nextSepar = dateStr.indexOf("/", secondSepar + 1);
                    if (nextSepar != -1)
                    {
                        //return new Date(1900, 0, 1);
                        return null;
                    }
                    else
                    {
                        var day = dateStr.substring(0, firstSepar);
                        var month = dateStr.substring(firstSepar + 1, secondSepar);
                        var year = dateStr.substring(secondSepar + 1);
                        month = month - 1;
                        //tester bis et nbre jour par mois
                        if (month < 0 || month > 11)
                        {
                            //   return "INVALID_MONTH";
                            return null;
                        }
                        var maxday = 30;
                        if (month == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11)
                        {
                            maxday = 31;
                        }
                        if (month == 1)
                        {
                            maxday = 28;
                        }
                        if (day < 1 || day > maxday)
                        {
                            //return "INVALID_DAY";
                            return null;
                        }
                        if (year < 2000 || year > 2100)
                        {
                            //return "INVALID_YEAR";
                            return null;
                        }
                        var dte = new Date(year, month, day);
                        return dte;
                    }
                }
            }

        },
        toString: function (dateSerial)
        {
            var dte = new Date(dateSerial);
            var day = dte.getDate();
            var month = dte.getMonth() + 1;
            var year = dte.getYear() + 1900;
            return day + "/" + month + "/" + year;
        }
    }